#ifdef PRECOMPILEDHEADERS
	#include "Tactical All.h"
#else
	#include "sgp.h"
	#include "overhead types.h"
	#include "Sound Control.h"
	#include "Soldier Control.h"
	#include "overhead.h"
	#include "Event Pump.h"
	#include "weapons.h"
	#include "Animation Control.h"
	#include "sys globals.h"
	#include "Handle UI.h"
	#include "Isometric Utils.h"
	#include "worldman.h"
	#include "math.h"
	#include "points.h"
	#include "ai.h"
	#include "los.h"
	#include "renderworld.h"
	#include "opplist.h"
	#include "interface.h"
	#include "message.h"
	#include "campaign.h"
	#include "items.h"
	#include "weapons.h"
	#include "text.h"
	#include "Soldier Profile.h"
	#include "tile animation.h"
	#include "Dialogue Control.h"
	#include "SkillCheck.h"
	#include "explosion control.h"
	#include "Quests.h"
	#include "Physics.h"
	#include "Random.h"
	#include "Vehicles.h"
	#include "bullets.h"
	#include "morale.h"
	#include "meanwhile.h"
	#include "SkillCheck.h"
	#include "gamesettings.h"
	#include "SaveLoadMap.h"
	#include "Debug Control.h"
	#include "expat.h"
	#include "XML.h"
#endif

struct
{
	PARSE_STAGE	curElement;

	INT8		szCharData[MAX_CHAR_DATA_LENGTH+1];
	ARMOURTYPE		curArmour;
	ARMOURTYPE *	curArray;
	UINT32			maxArraySize;
	
	UINT32			currentDepth;
	UINT32			maxReadDepth;
}
typedef armourParseData;

// marke strogg PCM
struct
{
	PARSE_STAGE	curElement;

	INT8		szCharData[MAX_CHAR_DATA_LENGTH+1];
	MERCPROFILESTRUCT		curPERSON;
	MERCPROFILESTRUCT *	curArray;
	UINT32			maxArraySize;
	
	UINT32			currentDepth;
	UINT32			maxReadDepth;
}
typedef PCMParseData;

MERCPROFILESTRUCT TEMPgMercProfiles[ 200 ] ;
// marke strogg PCM end

static void XMLCALL 
armourStartElementHandle(void *userData, const char *name, const char **atts)
{
	armourParseData * pData = (armourParseData *)userData;

	if(pData->currentDepth <= pData->maxReadDepth) //are we reading this element?
	{
		if(strcmp(name, "ARMOURLIST") == 0 && pData->curElement == ELEMENT_NONE)
		{
			pData->curElement = ELEMENT_LIST;

			memset(pData->curArray,0,sizeof(ARMOURTYPE)*pData->maxArraySize);

			pData->maxReadDepth++; //we are not skipping this element
		}
		else if(strcmp(name, "ARMOUR") == 0 && pData->curElement == ELEMENT_LIST)
		{
			pData->curElement = ELEMENT;

			memset(&pData->curArmour,0,sizeof(ARMOURTYPE));

			pData->maxReadDepth++; //we are not skipping this element
		}
		else if(pData->curElement == ELEMENT &&
				(strcmp(name, "uiIndex") == 0 ||
				strcmp(name, "ubArmourClass") == 0 ||
				strcmp(name, "ubProtection") == 0 ||
				strcmp(name, "ubDegradePercent") == 0 ))
		{
			pData->curElement = ELEMENT_PROPERTY;

			pData->maxReadDepth++; //we are not skipping this element
		}

		pData->szCharData[0] = '\0';
	}

	pData->currentDepth++;

}

static void XMLCALL
armourCharacterDataHandle(void *userData, const char *str, int len)
{
	armourParseData * pData = (armourParseData *)userData;

	if( (pData->currentDepth <= pData->maxReadDepth) && 
		(strlen(pData->szCharData) < MAX_CHAR_DATA_LENGTH)
	  ){
		strncat(pData->szCharData,str,__min((unsigned int)len,MAX_CHAR_DATA_LENGTH-strlen(pData->szCharData)));
	  }
}


static void XMLCALL
armourEndElementHandle(void *userData, const char *name)
{
	armourParseData * pData = (armourParseData *)userData;

	if(pData->currentDepth <= pData->maxReadDepth) //we're at the end of an element that we've been reading
	{
		if(strcmp(name, "ARMOURLIST") == 0)
		{
			pData->curElement = ELEMENT_NONE;
		}
		else if(strcmp(name, "ARMOUR") == 0)
		{
			pData->curElement = ELEMENT_LIST;

			if(pData->curArmour.uiIndex < pData->maxArraySize)
			{
				pData->curArray[pData->curArmour.uiIndex] = pData->curArmour; //write the armour into the table
			}
		}
		else if(strcmp(name, "uiIndex") == 0)
		{
			pData->curElement = ELEMENT;
			pData->curArmour.uiIndex   = (UINT32) atol(pData->szCharData);
		}
		else if(strcmp(name, "ubArmourClass") == 0)
		{
			pData->curElement = ELEMENT;
			pData->curArmour.ubArmourClass  = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "ubProtection") == 0)
		{
			pData->curElement = ELEMENT;
			pData->curArmour.ubProtection = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "ubDegradePercent") == 0)
		{
			pData->curElement = ELEMENT;
			pData->curArmour.ubDegradePercent   = (UINT8) atol(pData->szCharData);
		}

		pData->maxReadDepth--;
	}

	pData->currentDepth--;
}




BOOLEAN ReadInArmourStats(STR fileName)
{
	HWFILE		hFile;
	UINT32		uiBytesRead;
	UINT32		uiFSize;
	CHAR8 *		lpcBuffer;
	XML_Parser	parser = XML_ParserCreate(NULL);
	
	armourParseData pData;

	DebugMsg(TOPIC_JA2, DBG_LEVEL_3, "Loading Armours.xml" );

	// Open armour file
	hFile = FileOpen( fileName, FILE_ACCESS_READ, FALSE );
	if ( !hFile )
		return( FALSE );
	
	uiFSize = FileGetSize(hFile);
	lpcBuffer = (CHAR8 *) MemAlloc(uiFSize+1);

	//Read in block
	if ( !FileRead( hFile, lpcBuffer, uiFSize, &uiBytesRead ) )
	{
		MemFree(lpcBuffer);
		return( FALSE );
	}

	lpcBuffer[uiFSize] = 0; //add a null terminator

	FileClose( hFile );

	
	XML_SetElementHandler(parser, armourStartElementHandle, armourEndElementHandle);
	XML_SetCharacterDataHandler(parser, armourCharacterDataHandle);

	
	memset(&pData,0,sizeof(pData));
	pData.curArray = Armour;
	pData.maxArraySize = MAXITEMS; 
	
	XML_SetUserData(parser, &pData);


    if(!XML_Parse(parser, lpcBuffer, uiFSize, TRUE))
	{
		CHAR8 errorBuf[511];

		sprintf(errorBuf, "XML Parser Error in Armours.xml: %s at line %d", XML_ErrorString(XML_GetErrorCode(parser)), XML_GetCurrentLineNumber(parser));
		LiveMessage(errorBuf);

		MemFree(lpcBuffer);
		return FALSE;
	}

	MemFree(lpcBuffer);


	XML_ParserFree(parser);


	return( TRUE );
}
// marke strogg start PCM reading
static void XMLCALL 
PCMStartElementHandle(void *userData, const char *name, const char **atts)
{
	PCMParseData * pData = (PCMParseData *)userData;

	if(pData->currentDepth <= pData->maxReadDepth) //are we reading this element?
	{
		if(strcmp(name, "PCMLIST") == 0 && pData->curElement == ELEMENT_NONE)
		{
			pData->curElement = ELEMENT_LIST;

			memset(pData->curArray,0,sizeof(MERCPROFILESTRUCT)*pData->maxArraySize);

			pData->maxReadDepth++; //we are not skipping this element
		}
		else if(strcmp(name, "PERSON") == 0 && pData->curElement == ELEMENT_LIST)
		{
			pData->curElement = ELEMENT;

			memset(&pData->curPERSON,0,sizeof(MERCPROFILESTRUCT));

			pData->maxReadDepth++; //we are not skipping this element
		}
		else if(pData->curElement == ELEMENT &&
				(strcmp(name, "PCMindex") == 0 ||
				strcmp(name, "PCMprofile") == 0  || 
				strcmp(name, "PCMname") == 0  || 
				strcmp(name, "PCMnick") == 0  || 
				strcmp(name, "PCMpants") == 0  || 
				strcmp(name, "PCMvest") == 0  || 
				strcmp(name, "PCMskin") == 0  || 
				strcmp(name, "PCMhair") == 0  || 
				strcmp(name, "PCMgender") == 0  || 
				strcmp(name, "PCMevolution") == 0  || 
				strcmp(name, "PCMlearntohate") == 0  || 
				strcmp(name, "PCMvocalvolume") == 0  || 
				strcmp(name, "PCMdeathrate") == 0  || 
				strcmp(name, "PCMreputationtol") == 0  || 
				strcmp(name, "PCMbodytype") == 0  || 
				strcmp(name, "PCMmedical") == 0  || 
				strcmp(name, "PCMstrength") == 0  || 
				strcmp(name, "PCMlifemax") == 0  || 
				strcmp(name, "PCMlife") == 0  || 
				strcmp(name, "PCMdex") == 0  || 
				strcmp(name, "PCMexplo") == 0  || 
				strcmp(name, "PCMlead") == 0  || 
				strcmp(name, "PCMexplevel") == 0  || 
				strcmp(name, "PCMmark") == 0  || 
				strcmp(name, "PCMagil") == 0  || 
				strcmp(name, "PCMwisdom") == 0  || 
				strcmp(name, "PCMmech") == 0  || 
				strcmp(name, "PCMeyex") == 0  || 
				strcmp(name, "PCMeyey") == 0  || 
				strcmp(name, "PCMmouthx") == 0  || 
				strcmp(name, "PCMmouthy") == 0  || 
				strcmp(name, "PCMblinkfreq") == 0  || 
				strcmp(name, "PCMexpressfreq") == 0  || 
				strcmp(name, "PCMsectorx") == 0  || 
				strcmp(name, "PCMsectory") == 0  || 
				strcmp(name, "PCMsectorz") == 0  || 
				strcmp(name, "PCMgridno") == 0  || 
				strcmp(name, "PCMsalary") == 0  || 
				strcmp(name, "PCMweeklysalary") == 0  || 
				strcmp(name, "PCMbiweeklysalary") == 0  || 
				strcmp(name, "PCMperstrait") == 0  || 
				strcmp(name, "PCMattitude") == 0  || 
				strcmp(name, "PCMskill1") == 0  || 
				strcmp(name, "PCMskill2") == 0  || 
				strcmp(name, "PCMbuddy1") == 0  || 
				strcmp(name, "PCMbuddy2") == 0  || 
				strcmp(name, "PCMbuddy3") == 0  || 
				strcmp(name, "PCMbuddy4") == 0  || 
				strcmp(name, "PCMbuddy5") == 0  || 
				strcmp(name, "PCMhated1") == 0  || 
				strcmp(name, "PCMhated2") == 0  || 
				strcmp(name, "PCMhated3") == 0  || 
				strcmp(name, "PCMhated4") == 0  || 
				strcmp(name, "PCMhated5") == 0  || 
				strcmp(name, "PCMlearntolike") == 0  || 
				strcmp(name, "PCMcivgroup") == 0  || 
				strcmp(name, "PCMneedforsleep") == 0  || 
				strcmp(name, "PCMinv1") == 0  || 
				strcmp(name, "PCMinvcount1") == 0  || 
				strcmp(name, "PCMinvcond1") == 0  || 
				strcmp(name, "PCMinv2") == 0  || 
				strcmp(name, "PCMinvcount2") == 0  || 
				strcmp(name, "PCMinvcond2") == 0  || 
				strcmp(name, "PCMinv3") == 0  || 
				strcmp(name, "PCMinvcount3") == 0  || 
				strcmp(name, "PCMinvcond3") == 0  || 				
				strcmp(name, "PCMinv4") == 0  || 
				strcmp(name, "PCMinvcount4") == 0  || 
				strcmp(name, "PCMinvcond4") == 0  || 				
				strcmp(name, "PCMinv5") == 0  || 
				strcmp(name, "PCMinvcount5") == 0  || 
				strcmp(name, "PCMinvcond5") == 0  || 				
				strcmp(name, "PCMinv6") == 0  || 
				strcmp(name, "PCMinvcount6") == 0  || 
				strcmp(name, "PCMinvcond6") == 0  || 				
				strcmp(name, "PCMinv7") == 0  || 
				strcmp(name, "PCMinvcount7") == 0  || 
				strcmp(name, "PCMinvcond7") == 0  || 				
				strcmp(name, "PCMinv8") == 0  || 
				strcmp(name, "PCMinvcount8") == 0  || 
				strcmp(name, "PCMinvcond8") == 0  || 				
				strcmp(name, "PCMinv9") == 0  || 
				strcmp(name, "PCMinvcount9") == 0  || 
				strcmp(name, "PCMinvcond9") == 0  || 
				strcmp(name, "PCMinv10") == 0  || 
				strcmp(name, "PCMinvcount10") == 0  || 
				strcmp(name, "PCMinvcond10") == 0  || 
				strcmp(name, "PCMinv11") == 0  || 
				strcmp(name, "PCMinvcount11") == 0  || 
				strcmp(name, "PCMinvcond11") == 0  || 
				strcmp(name, "PCMinv12") == 0  || 
				strcmp(name, "PCMinvcount12") == 0  || 
				strcmp(name, "PCMinvcond12") == 0  || 
				strcmp(name, "PCMinv13") == 0  || 
				strcmp(name, "PCMinvcount13") == 0  || 
				strcmp(name, "PCMinvcond13") == 0  || 
				strcmp(name, "PCMinv14") == 0  || 
				strcmp(name, "PCMinvcount14") == 0  || 
				strcmp(name, "PCMinvcond14") == 0  || 
				strcmp(name, "PCMinv15") == 0  || 
				strcmp(name, "PCMinvcount15") == 0  || 
				strcmp(name, "PCMinvcond15") == 0  || 
				strcmp(name, "PCMinv16") == 0  || 
				strcmp(name, "PCMinvcount16") == 0  || 
				strcmp(name, "PCMinvcond16") == 0  || 
				strcmp(name, "PCMinv17") == 0  || 
				strcmp(name, "PCMinvcount17") == 0  || 
				strcmp(name, "PCMinvcond17") == 0  || 
				strcmp(name, "PCMinv18") == 0  || 
				strcmp(name, "PCMinvcount18") == 0  || 
				strcmp(name, "PCMinvcond18") == 0  || 
				strcmp(name, "PCMinv19") == 0  || 
				strcmp(name, "PCMinvcount19") == 0  || 
				strcmp(name, "PCMinvcond19") == 0  || 
				strcmp(name, "PCMcash") == 0  || 
				strcmp(name, "PCMsmalleyex") == 0  || 
				strcmp(name, "PCMsmalleyey") == 0  || 
				strcmp(name, "PCMsmallmouthx") == 0  || 
				strcmp(name, "PCMsmallmouthy") == 0  || 
				strcmp(name, "PCMusealternateSCRIPTname") == 0  || 
				strcmp(name, "PCMforceinsert") == 0	|| 
				strcmp(name, "PCMeffectuponfriendly") == 0  || 
				strcmp(name, "PCMeffectupondirect") == 0  || 
				strcmp(name, "PCMeffectuponthreaten") == 0  || 
				strcmp(name, "PCMeffectuponrecruit") == 0  || 
				strcmp(name, "PCMfriendlyTOfriendly") == 0  || 
				strcmp(name, "PCMfriendlyTOdirect") == 0  || 
				strcmp(name, "PCMfriendlyTOthreat") == 0  || 
				strcmp(name, "PCMfriendlyTOrecruit") == 0  || 
				strcmp(name, "PCMdirectTOfriendly") == 0  || 
				strcmp(name, "PCMdirectTOdirect") == 0  || 
				strcmp(name, "PCMdirectTOthreat") == 0  || 
				strcmp(name, "PCMdirectTOrecruit") == 0  || 
				strcmp(name, "PCMthreatenTOfriendly") == 0  || 
				strcmp(name, "PCMthreatenTOdirect") == 0  || 
				strcmp(name, "PCMthreatenTOthreat") == 0  || 
				strcmp(name, "PCMthreatenTOrecruit") == 0  || 
				strcmp(name, "PCMapproachvalONE") == 0  || 
				strcmp(name, "PCMapproachvalTWO") == 0  || 
				strcmp(name, "PCMapproachvalTHREE") == 0  || 
				strcmp(name, "PCMapproachvalFOUR") == 0  || 
				strcmp(name, "PCMroomstartONE") == 0  || 
				strcmp(name, "PCMroomendONE") == 0  || 
				strcmp(name, "PCMroomstartTWO") == 0  || 
				strcmp(name, "PCMroomendTWO") == 0
				))
		{
			pData->curElement = ELEMENT_PROPERTY;

			pData->maxReadDepth++; //we are not skipping this element
		}

		pData->szCharData[0] = '\0';
	}

	pData->currentDepth++;

}

static void XMLCALL
PCMCharacterDataHandle(void *userData, const char *str, int len)
{
	PCMParseData * pData = (PCMParseData *)userData;

	if( (pData->currentDepth <= pData->maxReadDepth) && 
		(strlen(pData->szCharData) < MAX_CHAR_DATA_LENGTH)
	  ){
		strncat(pData->szCharData,str,__min((unsigned int)len,MAX_CHAR_DATA_LENGTH-strlen(pData->szCharData)));
	  }
}


static void XMLCALL
PCMEndElementHandle(void *userData, const char *name)
{

	PCMParseData * pData = (PCMParseData *)userData;

	if(pData->currentDepth <= pData->maxReadDepth) //we're at the end of an element that we've been reading
	{
		if(strcmp(name, "PCMLIST") == 0)
		{
			pData->curElement = ELEMENT_NONE;
		}
		else if(strcmp(name, "PERSON") == 0)
		{
			pData->curElement = ELEMENT_LIST;
			// Ok this is a hack but we need a value to cross reference a profile
		//	if(pData->curPERSON.uiAttnSound < pData->maxArraySize)
		//	{// Ok this is a hack but we need an index value stored
		//		pData->curArray[pData->curPERSON.uiAttnSound] = pData->curPERSON; //write the PERSON into the table
		//	}
		}
		else if(strcmp(name, "PCMindex") == 0)
		{ 
			pData->curElement = ELEMENT;			
		}
		else if(strcmp(name, "PCMprofile") == 0)
		{ // redefine this to cross reference into the right profile field
			pData->curElement = ELEMENT;
			pData->curPERSON.uiAttnSound = (UINT32) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMname") == 0)
		{ 
			pData->curElement = ELEMENT;
			for(int i=0;i<min((int)strlen(pData->szCharData), 30);i++)
			{				
			gMercProfiles[ pData->curPERSON.uiAttnSound ].zName[i] = pData->szCharData[i];
			}
			gMercProfiles[ pData->curPERSON.uiAttnSound ].zName[i+1] = 0 ; // set end point to name as old name might be longer causing trouble
		}
		else if(strcmp(name, "PCMnick") == 0)
		{ 
			pData->curElement = ELEMENT;
			for(int i=0;i<min((int)strlen(pData->szCharData), 10);i++)
			{				
			gMercProfiles[ pData->curPERSON.uiAttnSound ].zNickname[i] = pData->szCharData[i];
			}
			gMercProfiles[ pData->curPERSON.uiAttnSound ].zNickname[i+1] = 0 ; // set end point to name as old name might be longer causing trouble
			// if person has a nickname selected store face id as theyre not loaded via prof.dat
			gMercProfiles[ pData->curPERSON.uiAttnSound ].ubFaceIndex = pData->curPERSON.uiAttnSound ;
		}		
		else if(strcmp(name, "PCMpants") == 0)
		{ 
			pData->curElement = ELEMENT;
			strcpy( gMercProfiles[ pData->curPERSON.uiAttnSound ].PANTS, pData->szCharData );
		}
		else if(strcmp(name, "PCMvest") == 0)
		{ 
			pData->curElement = ELEMENT;
			strcpy( gMercProfiles[ pData->curPERSON.uiAttnSound ].VEST, pData->szCharData );
		}
		else if(strcmp(name, "PCMskin") == 0)
		{ 
			pData->curElement = ELEMENT;
			strcpy( gMercProfiles[ pData->curPERSON.uiAttnSound ].SKIN, pData->szCharData );
		}
		else if(strcmp(name, "PCMhair") == 0)
		{ 
			pData->curElement = ELEMENT;
			strcpy( gMercProfiles[ pData->curPERSON.uiAttnSound ].HAIR, pData->szCharData );
		}
		else if(strcmp(name, "PCMgender") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bSex = (INT8) atol(pData->szCharData);
		}		
		else if(strcmp(name, "PCMevolution") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bEvolution = (INT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMlearntohate") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bLearnToHate = (INT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMvocalvolume") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bVocalVolume = (INT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMdeathrate") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bDeathRate = (INT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMreputationtol") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bReputationTolerance = (INT8) atol(pData->szCharData);
		}		
		else if(strcmp(name, "PCMbodytype") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].ubBodyType = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMmedical") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bMedical = (INT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMstrength") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bStrength = (INT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMlifemax") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bLifeMax = (INT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMlife") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bLife = (INT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMdex") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bDexterity = (INT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMexplo") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bExplosive = (INT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMlead") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bLeadership = (INT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMexplevel") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bExpLevel = (INT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMmark") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bMarksmanship = (INT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMagil") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bAgility = (INT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMwisdom") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bWisdom = (INT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMmech") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bMechanical = (INT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMeyex") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].usEyesX = (UINT16) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMeyey") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].usEyesY = (UINT16) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMmouthx") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].usMouthX = (UINT16) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMmouthy") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].usMouthY = (UINT16) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMblinkfreq") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].uiBlinkFrequency = (UINT32) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMexpressfreq") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].uiExpressionFrequency = (UINT32) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMsectorx") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].sSectorX = (UINT16) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMsectory") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].sSectorY = (UINT16) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMsectorz") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bSectorZ = (INT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMgridno") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].sGridNo = (INT16) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMsalary") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].sSalary = (INT16) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMweeklysalary") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].uiWeeklySalary = (UINT32) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMbiweeklysalary") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].uiBiWeeklySalary = (UINT32) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMperstrait") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bPersonalityTrait = (INT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMattitude") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bAttitude = (INT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMskill1") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bSkillTrait = (INT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMskill2") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bSkillTrait2 = (INT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMbuddy1") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bBuddy[0] = (INT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMbuddy2") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bBuddy[1] = (INT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMbuddy3") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bBuddy[2] = (INT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMbuddy4") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bBuddy[3] = (INT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMbuddy5") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bBuddy[4] = (INT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMhated1") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bHated[0] = (INT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMhated2") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bHated[1] = (INT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMhated3") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bHated[2] = (INT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMhated4") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bHated[3] = (INT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMhated5") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bHated[4] = (INT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMlearntolike") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bLearnToLike = (INT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMcivgroup") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].ubCivilianGroup = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMneedforsleep") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].ubNeedForSleep = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinv1") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].inv[0] = (UINT16) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinvcount1") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bInvNumber[0] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinvcond1") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bInvStatus[0] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinv2") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].inv[1] = (UINT16) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinvcount2") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bInvNumber[1] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinvcond2") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bInvStatus[1] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinv3") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].inv[2] = (UINT16) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinvcount3") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bInvNumber[2] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinvcond3") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bInvStatus[2] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinv4") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].inv[3] = (UINT16) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinvcount4") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bInvNumber[3] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinvcond4") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bInvStatus[3] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinv5") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].inv[4] = (UINT16) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinvcount5") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bInvNumber[4] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinvcond5") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bInvStatus[4] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinv6") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].inv[5] = (UINT16) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinvcount6") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bInvNumber[5] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinvcond6") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bInvStatus[5] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinv7") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].inv[6] = (UINT16) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinvcount7") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bInvNumber[6] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinvcond7") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bInvStatus[6] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinv8") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].inv[7] = (UINT16) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinvcount8") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bInvNumber[7] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinvcond8") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bInvStatus[7] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinv9") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].inv[8] = (UINT16) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinvcount9") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bInvNumber[8] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinvcond9") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bInvStatus[8] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinv10") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].inv[9] = (UINT16) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinvcount10") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bInvNumber[9] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinvcond10") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bInvStatus[9] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinv11") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].inv[10] = (UINT16) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinvcount11") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bInvNumber[10] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinvcond11") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bInvStatus[10] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinv12") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].inv[11] = (UINT16) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinvcount12") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bInvNumber[11] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinvcond12") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bInvStatus[11] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinv13") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].inv[12] = (UINT16) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinvcount13") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bInvNumber[12] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinvcond13") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bInvStatus[12] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinv14") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].inv[13] = (UINT16) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinvcount14") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bInvNumber[13] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinvcond14") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bInvStatus[13] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinv15") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].inv[14] = (UINT16) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinvcount15") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bInvNumber[14] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinvcond15") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bInvStatus[14] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinv16") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].inv[15] = (UINT16) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinvcount16") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bInvNumber[15] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinvcond16") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bInvStatus[15] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinv17") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].inv[16] = (UINT16) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinvcount17") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bInvNumber[16] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinvcond17") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bInvStatus[16] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinv18") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].inv[17] = (UINT16) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinvcount18") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bInvNumber[17] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinvcond18") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bInvStatus[17] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinv19") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].inv[18] = (UINT16) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinvcount19") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bInvNumber[18] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMinvcond19") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].bInvStatus[18] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMcash") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].iBalance = (INT32) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMsmalleyex") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].uiCurseSound = (UINT32) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMsmalleyey") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].uiDieSound = (UINT32) atol(pData->szCharData);
		}

		if(strcmp(name, "PCMsmallmouthx") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].uiGoodSound = (UINT32) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMsmallmouthy") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].uiGruntSound = (UINT32) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMusealternateSCRIPTname") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].uiOkSound = (UINT32) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMforceinsert") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].uiGrunt2Sound = (UINT32) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMeffectuponfriendly") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].usApproachFactor[0] = (UINT16) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMeffectupondirect") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].usApproachFactor[1] = (UINT16) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMeffectuponthreaten") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].usApproachFactor[2] = (UINT16) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMeffectuponrecruit") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].usApproachFactor[3] = (UINT16) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMfriendlyTOfriendly") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].ubApproachMod[0][0] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMfriendlyTOdirect") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].ubApproachMod[0][1] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMfriendlyTOthreat") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].ubApproachMod[0][2] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMfriendlyTOrecruit") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].ubApproachMod[0][3] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMdirectTOfriendly") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].ubApproachMod[1][0] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMdirectTOdirect") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].ubApproachMod[1][1] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMdirectTOthreat") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].ubApproachMod[1][2] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMdirectTOrecruit") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].ubApproachMod[1][3] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMthreatenTOfriendly") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].ubApproachMod[2][0] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMthreatenTOdirect") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].ubApproachMod[2][1] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMthreatenTOthreat") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].ubApproachMod[2][2] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMthreatenTOrecruit") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].ubApproachMod[2][3] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMapproachvalONE") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].ubApproachVal[0] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMapproachvalTWO") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].ubApproachVal[1] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMapproachvalTHREE") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].ubApproachVal[2] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMapproachvalFOUR") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].ubApproachVal[3] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMroomstartONE") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].ubRoomRangeStart[0] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMroomendONE") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].ubRoomRangeEnd[0] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMroomstartTWO") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].ubRoomRangeStart[1] = (UINT8) atol(pData->szCharData);
		}
		else if(strcmp(name, "PCMroomendTWO") == 0)
		{ 
			pData->curElement = ELEMENT;
			gMercProfiles[ pData->curPERSON.uiAttnSound ].ubRoomRangeEnd[1] = (UINT8) atol(pData->szCharData);
		}


		// uhuahu -- what a helluvalot work 
		

		pData->maxReadDepth--;
	}

	pData->currentDepth--;
}

BOOLEAN ReadInPCMStats(STR fileName)
{
	HWFILE		hFile;
	UINT32		uiBytesRead;
	UINT32		uiFSize;
	CHAR8 *		lpcBuffer;
	XML_Parser	parser = XML_ParserCreate(NULL);
	
	PCMParseData pData;

	DebugMsg(TOPIC_JA2, DBG_LEVEL_3, "Loading PCM.xml" );

	// Open PCM file
	hFile = FileOpen( fileName, FILE_ACCESS_READ, FALSE );
	if ( !hFile )
		return( FALSE );
	
	uiFSize = FileGetSize(hFile);
	lpcBuffer = (CHAR8 *) MemAlloc(uiFSize+1);

	//Read in block
	if ( !FileRead( hFile, lpcBuffer, uiFSize, &uiBytesRead ) )
	{
		MemFree(lpcBuffer);
		return( FALSE );
	}

	lpcBuffer[uiFSize] = 0; //add a null terminator

	FileClose( hFile );

	
	XML_SetElementHandler(parser, PCMStartElementHandle, PCMEndElementHandle);
	XML_SetCharacterDataHandler(parser, PCMCharacterDataHandle);

	
	memset(&pData,0,sizeof(pData));
	pData.curArray = TEMPgMercProfiles;
	pData.maxArraySize = 200;  // 200 profiles
	
	XML_SetUserData(parser, &pData);


    if(!XML_Parse(parser, lpcBuffer, uiFSize, TRUE))
	{
		CHAR8 errorBuf[511];

		sprintf(errorBuf, "XML Parser Error in PCM.xml: %s at line %d", XML_ErrorString(XML_GetErrorCode(parser)), XML_GetCurrentLineNumber(parser));
		LiveMessage(errorBuf);

		MemFree(lpcBuffer);
		return FALSE;
	}

	MemFree(lpcBuffer);


	XML_ParserFree(parser);


	return( TRUE );
}

// marke strogg end PCM reading



BOOLEAN WriteArmourStats()
{
	//DebugMsg (TOPIC_JA2,DBG_LEVEL_3,"writearmourstats");
	HWFILE		hFile;

	//Debug code; make sure that what we got from the file is the same as what's there
	// Open a new file
	hFile = FileOpen( "TABLEDATA\\Armour out.xml", FILE_ACCESS_WRITE | FILE_CREATE_ALWAYS, FALSE );
	if ( !hFile )
		return( FALSE );
	
	{
		UINT32 cnt;

		FilePrintf(hFile,"<ARMOURLIST>\r\n");
		for(cnt = 0;cnt < MAXITEMS;cnt++)
		{

			FilePrintf(hFile,"\t<ARMOUR>\r\n");

			FilePrintf(hFile,"\t\t<uiIndex>%d</uiIndex>\r\n",								cnt );
			FilePrintf(hFile,"\t\t<ubArmourClass>%d</ubArmourClass>\r\n",								Armour[cnt].ubArmourClass  );
			FilePrintf(hFile,"\t\t<ubProtection>%d</ubProtection>\r\n",								Armour[cnt].ubProtection   );
			FilePrintf(hFile,"\t\t<ubDegradePercent>%d</ubDegradePercent>\r\n",								Armour[cnt].ubDegradePercent   );

			FilePrintf(hFile,"\t</ARMOUR>\r\n");
		}
		FilePrintf(hFile,"</ARMOURLIST>\r\n");
	}
	FileClose( hFile );

	return( TRUE );
}